unit DemoSrc;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, OleCtrls, LYTECCOMMV5Lib_TLB;

type
  TForm1 = class(TForm)
    Pict: TImage;
    Button1: TButton;
    Button2: TButton;
    LYTec: TLYTecCommV51;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
Const   Version   =  64;    // AͿ:64BͿ80
        ComPort   =   1;    // ͨѶ
        BaudRate  = 28800;  // ͨѶ
        Delay     =  1500;  // ͨѶʱ
        LedNum    =   0;    // ƿ
        LedWidth  = 384;    // Ļ
        LedHeight =  64;    // Ļ߶
        LedColor  =   1;    // 0:ɫ,1:˫ɫ

procedure TForm1.Button1Click(Sender: TObject);
Const   _Role : Array[0..7] Of Byte = (128,64,32,16,8,4,2,1);
Var     Buff    : Array [0..511,0..127] Of Byte;
        i,j,k   : SmallInt;
        VR,VG   : Byte;
        Col     : LongInt;
        RetV    : Boolean;
        ProgList : Array[0..9,0..5] Of Byte;
begin

    // 
    For i:=0 To 511 Do
        For j:=0 To 127 Do
            Buff[i,j] := 0;

    For i:=0 To LedHeight-1 Do              // ͼĸ߶
    Begin
        For j:=0 to (LedWidth Div 8)-1 Do   // ͼĿ
        Begin
            For k:=0 To 7 Do
            Begin
                Col := Pict.Canvas.Pixels[j*8+k,i]; // ȡɫ
                VR := Col Mod 256;                  // ɫ
                VG := (Col Div 256) Mod 256;        // ɫ
                If VR>127 Then
                Begin
                    If Version=80 Then Buff[i,j] := Buff[i,j] Or _Role[k]   // B
                    Else               Buff[i,128-(LedWidth Div 8)+j] :=    // AҶ
                                            Buff[i,128-(LedWidth Div 8)+j] Or _Role[k]
                End;
                If VG>127 Then
                Begin                   // ɫںɫ֮
                    If Version=80 Then Buff[i+LedHeight,j] := Buff[i+LedHeight,j] Or _Role[k]
                    Else               Buff[i+LedHeight,128-(LedWidth Div 8)+j] :=
                                            Buff[i+LedHeight,128-(LedWidth Div 8)+j] Or _Role[k];
                End;
            End
        End
    End;

    If Not LYTec.ComInitial(Version,ComPort,BaudRate,Delay,LedNum,LedWidth,LedHeight,LedColor)
    Then  MessageBox(Self.Handle,'ͨѶʼʧ','Demo',MB_OK)
    Else
        Begin
            j := LYTec.GetPictureTimes;
            i := 0;
            RetV := True;
            While (i<j) And RetV Do
            Begin
                RetV := LYTec.SendPicture(0,i,Integer(@Buff[0,0]));
                i := i+1;
            End;
            If Not RetV Then
                MessageBox(Self.Handle,'ͨѶϹ,ʧ','Demo',MB_OK)
            Else
            Begin
                // ֻз˽Ŀ,ͼƬŻȷʾ
                ProgList[0,0] := 2;     // 뷽ʽΪ2
                ProgList[0,1] := 1;     // ٶΪ1
                ProgList[0,2] := 3;     // ˳ʽΪ3
                ProgList[0,3] := 0;     // 
                ProgList[0,4] := 50;    // ͣ5
                ProgList[0,5] := 0;     // ʾʱ
                If LYTec.SendProgList(1,Integer(@ProgList[0,0]))
                Then MessageBox(Self.Handle,'','Demo',MB_OK)
                Else MessageBox(Self.Handle,'ͨѶϹ,ʧ','Demo',MB_OK);
            End
        End;
    LYTec.Close;
end;


//ʾ Aл񹲺͹B
//  A      Ϊɫ
//      л   Ϊɫ
//         Ϊɫ
//      ͹ Ϊɫ
//      B      Ϊɫ
procedure TForm1.Button2Click(Sender: TObject);
Var   Str     : String;
begin
    Str := #2'A'#1'л'#2''#3'͹'#2'B';
    If Not LYTec.ComInitial(Version,ComPort,BaudRate,Delay,LedNum,LedWidth,LedHeight,LedColor)
    Then MessageBox(Self.Handle,'ͨѶʼʧ','Demo',MB_OK)
    Else
        If Not LYTec.GetHZLibState
        Then MessageBox(Self.Handle,'ƿֿͨѶʧ','Demo',MB_OK)
        Else
            If LYTec.ShowString(0,LedWidth-8*16,0,1,Integer(PChar(Str)))
            Then MessageBox(Self.Handle,'','Demo',MB_OK)
            Else MessageBox(Self.Handle,'ͨѶϹ,ʧ','Demo',MB_OK);
    LYTec.Close;
end;

end.
